/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class HSCException
extends Exception {
    public static final int HSC_ERROR_UNKNOWN = 0;
    protected String mNestedExceptionMsg = null;
    protected String mNestedExceptionStack = null;
    protected int mErrorType = 0;

    public HSCException(String string, Throwable throwable) {
        super(string);
        this.processNestedException(throwable);
    }

    public HSCException(int n, String string, Throwable throwable) {
        super(string);
        this.mErrorType = n;
        this.processNestedException(throwable);
    }

    public HSCException(int n, String string) {
        super(string);
        this.mErrorType = n;
    }

    public HSCException(String string) {
        super(string);
    }

    public HSCException(Throwable throwable) {
        super((Throwable)null);
        this.processNestedException(throwable);
    }

    public String getMessage() {
        String string = super.getMessage();
        if (string != null && this.mNestedExceptionMsg != null) {
            string = string + "\nThe nested exception message is:\n";
            return string + this.mNestedExceptionMsg;
        }
        if (string == null && this.mNestedExceptionMsg != null) {
            return this.mNestedExceptionMsg;
        }
        return string;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.mNestedExceptionStack != null) {
            printStream.println("The stack trace for nested exception is:");
            printStream.println(this.mNestedExceptionStack);
        }
    }

    private void processNestedException(Throwable throwable) {
        try {
            this.mNestedExceptionMsg = throwable.getMessage();
            if (this.mNestedExceptionMsg == null || this.mNestedExceptionMsg.equals("")) {
                this.mNestedExceptionMsg = throwable.toString();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream, true);
            throwable.printStackTrace(printStream);
            this.mNestedExceptionStack = byteArrayOutputStream.toString();
            printStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

